REBOL [
	title: "Client de messagerie"
	author: "Olivier Auverlot"
	version: 1.0
]

lire-parametre: does [
	if error? try [
		param: to-integer second entree
		return true
	] [ return false ]
]

informations-utilisateur: does [
	compte: ask "Nom du compte de messagerie:"
	password: ask/hide "Mot de passe:"
	courriers-entrants: to-url join "pop://" [ 
		compte ":" password "@" system/schemes/pop/host 
	]
]


affiche: function [ textes ] [ num chaine sortie spaces ] [
	sortie: copy ""
	colonnes: head colonnes
	repeat num (length? textes) [
		spaces: copy ""
		chaine: copy/part (to-string textes/:num) colonnes/:num
		insert/dup spaces " " (colonnes/:num - (length? chaine))
		sortie: copy join sortie [ chaine spaces ]
	]
	print sortie
]

liste-messages: function [] [ num ] [
	colonnes: copy [ 5 30 30 30 ]
	if error? try [
		boite: open courriers-entrants
		repeat num (length? boite) [
			email: import-email boite/:num
			affiche reduce [ num email/from email/date email/subject ]
		]
		close boite
	] [ print "Impossible d'afficher la liste des messages" ]
]

statistiques: does [
	if error? try [
		boite: open courriers-entrants
		print [ "Nombre de messages:"	(length? boite) ]
		print [ "Taille de la boite (en octets):" boite/locals/total-size ]
		close boite
	] [ print "Impossible d'afficher les statistiques" ]
]

consultation: does [
	if error? try [
		boite: open courriers-entrants
		email: import-email boite/:param
		print email/content
		close boite	
	] [ print "Impossible d'afficher le contenu du message" ]
]

sauvegarde: does [
	if error? try [
		boite: open courriers-entrants
		email: import-email boite/:param
		write/lines to-file ask "Nom du fichier:" email/content
		close boite
	] [ print "Impossible de sauvegarder le message" ]
]

detruire: does [
	if error? try [
		boite: open courriers-entrants
		loop (param - 1) [ boite: next boite ]
		remove boite
		close boite
		print [ "Message" param "effac" ]
	] [ print "Impossible d'effacer le message" ]
]

vider: does [
	if error? try [
		boite: open courriers-entrants
		clear boite
		close boite
		print "Votre boite aux lettres est vide"
	] [ print "Impossible de vider votre boite aux lettres" ]
]

poster: function [] [ txt ligne email sujet ] [
	txt: copy ""
	email: to-email ask "Adresse email du destinataire: "
	sujet: ask "Sujet du message: "
	print {Contenu du message ("**" pour terminer)"}
	print "---------------------------------------"
	until [
		ligne: ask ">"
		append txt reduce [ ligne newline ]
		(found? find ligne "**")
	]
	replace txt "**" ""
	if error? try [
		send/header email txt make system/standard/email [
			subject: :sujet
		]
	] [ print "Impossible d'envoyer le message" ]
]

aide: does [
	colonnes: copy [ 6 74 ]	
	commandes: head commandes
	forall commandes [
		affiche first commandes
	]
	
]

commandes: copy [
	[ "L" "Liste des messages" ]
	[ "S" "Statistiques d'utilisation de votre boite" ]
	[ "C n" "Consultation d'un message" ]
	[ "E n" "Sauvegarde d'un message" ]
	[ "P" "Rdaction et envoi d'un message" ]
	[ "D n" "Destruction d'un message" ]
	[ "V" "Effacement des messages prsents dans votre boite" ]
	[ "I" "Configuration de votre compte" ]
	[ "Q" "Quitter le logiciel" ]
	[ "A" "Aide" ]
]

informations-utilisateur
print "A pour obtenir de l'aide"
forever [
	if error? try [
		entree: parse trim ask "^/COMMANDE >" ""
		ret: true
		if (length? entree) = 2 [ ret: lire-parametre ]
		either ret = true [
			switch/default (uppercase first entree) [
				"L" [ liste-messages ]
				"S" [ statistiques ]
				"C" [ consultation ]
				"E" [ sauvegarde ]
				"P" [ poster ]
				"D" [ detruire ]
				"V" [ vider ]
				"I" [ informations-utilisateur ]
					"Q" [ quit ]
				"A" [ aide ]
			] [ print "Commande indisponible" ]
		] [ print "La syntaxe de la commande est incorrecte" ]
	] []
]